function [COM_data] = COM_computation(Data, varargin)

%% Use http://www.kwon3d.com/theory/grf/cop.html for COP calculation!

if nargin == 1
    weights_inverse = diag(ones(1,size(Data,2)));
else
    weights_inverse = varargin{1};
end
% Data_Markers_gapfilled_cut(:,6) = [];
% Trails = size(Data_Markers_gapfilled_cut,2);

        % Weigh data (if weights were available)
        Data_w = Data/weights_inverse; % Same as multiplication with weights!
        bodymass = sum(sum(inv(weights_inverse)))/3;
        
        % Careful with signs! Not always sincronized COP with marker data!
        COM_x = +1/bodymass*sum(Data_w(:,1:3:end-2),2);
        COM_y = +1/bodymass*sum(Data_w(:,2:3:end-1),2);
        COM_z = +1/bodymass*sum(Data_w(:,3:3:end-0),2);
        
        COM_data = [COM_x, COM_y, COM_z]; % Not Centered

end